require( "quest/m3_maze2/convout.lua" );
require( "quest/m3_maze_shared/m3_maze_shared.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:FaceNow(DIR.S);
		actor:SetWalkSpeed(flo_speed);
		actor:JumpToNamedPoint("flo");
		actor:SetScale(0.6);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		maze_position = { row = 1, col = 7 } 
		
		actor:StartProc(goto_new_maze_position);
		
		scene:SetCameraFollowActor(actor);
	end;
	
	on_arrive = function(flo, flo2)
		convproc("FLO", "quip_bigcorp_music");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function talk_to_cubicle2(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle2_walkto");
	wait_walkto();
	
	flo:Face(DIR.W);
	
	scene.ROSIE:LastingEmotion();
	scene.ROSIE:SetEmotion("look");
	
	scene.ROSIE:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("ToTalkE");
	wait_anim(scene.ROSIE);
	
	scene.ROSIE:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("DoStandE_look");
	
	conv_multiple(flo, "conv_maze2_rosie", "A", 2);
	
	scene.ROSIE:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("FromTalkE");
	wait_anim(scene.ROSIE);
	
	scene.ROSIE:QuickEmotion();
	scene.ROSIE:ClearEmotion();
	
	scene.ROSIE:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("DoStandE");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle2_spec = 
{
	name = "ROSIE";
	halo = "quest/objects/cubicle2";
	gfx = { anim = "anim/rosie/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle2_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle2");
		actor:FaceNow(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle2_speed);
		actor:FaceNow(DIR.E);
		actor.closeEnoughPos = { row = 3, col = 2 };
	end;
	
	on_arrive = function(flo, cubicle2)
		if ( maze_position.row == cubicle2.closeEnoughPos.row and maze_position.col == cubicle2.closeEnoughPos.col ) then
			flo:StartProc(talk_to_cubicle2);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

function talk_to_cubicle3(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle3_walkto");
	wait_walkto();
	
	flo:Face(DIR.E);
	
	scene.SEYMOUR:LastingEmotion();
	scene.SEYMOUR:SetEmotion("look");
	
	scene.SEYMOUR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("ToTalkW");
	wait_anim(scene.SEYMOUR);
	
	scene.SEYMOUR:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("DoStandW_look");
	
	conv_multiple(flo, "conv_maze2_seymour", "A", 2);
	
	scene.SEYMOUR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("FromTalkW");
	wait_anim(scene.SEYMOUR);
	
	scene.SEYMOUR:QuickEmotion();
	scene.SEYMOUR:ClearEmotion();
	
	scene.SEYMOUR:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("DoStandW");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle3_spec = 
{
	name = "SEYMOUR";
	halo = "quest/objects/cubicle3";
	gfx = { anim = "anim/seymour/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle3_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle3");
		actor:FaceNow(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle3_speed);
		actor.closeEnoughPos = { row = 6, col = 5 };
	end;
	
	on_arrive = function(flo, cubicle3)
		if ( maze_position.row == cubicle3.closeEnoughPos.row and maze_position.col == cubicle3.closeEnoughPos.col ) then
			flo:StartProc(talk_to_cubicle3);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

function set_flo_speech_bubble_alt()
	scene.FLO:ModifySaySpec { mouth_in_actor = { x = 30, y = -145 } }
	scene.FLO:ModifySaySpec 
		{ 
			bubble_0 = bubble_b0_spec,
			bubble_1 = bubble_b1_spec,
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEVFLIP 
		};
end

function set_flo_speech_bubble_default()
	prepare_actor_text(scene.FLO, flo_text_spec);
end

function talk_to_cubicle4(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle4_walkto");
	wait_walkto();
	
	flo:Face(DIR.W);
	
	scene.NORBERT:LastingEmotion();
	scene.NORBERT:SetEmotion("talk");
	
	scene.NORBERT:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("ToTalkE");
	wait_anim(scene.NORBERT);
	
	scene.NORBERT:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("DoStandE_talk");
	
	set_flo_speech_bubble_alt();
	
	run_super_conversation(flo, "conv_maze2_norbertA");
	
	set_flo_speech_bubble_default();
	
	scene.NORBERT:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("FromTalkE");
	wait_anim(scene.NORBERT);
	
	scene.NORBERT:QuickEmotion();
	scene.NORBERT:ClearEmotion();
	
	scene.NORBERT:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("DoStandE");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle4_spec = 
{
	name = "NORBERT";
	halo = "quest/objects/cubicle4";
	gfx = { anim = "anim/norbert/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle4_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = 0, y = -60 } }
		actor:ModifySaySpec 
		{ 
			bubble_0 = bubble_b0_spec,
			bubble_1 = bubble_b1_spec,
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP, 
		};
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle4");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle4_speed);
		actor:FaceNow(DIR.E);
		actor:SetScale(.7);
		actor.closeEnoughPos = { row = 2, col = 4 };
	end;
	
	on_arrive = function(flo, cubicle4)
		if ( maze_position.row == cubicle4.closeEnoughPos.row and maze_position.col == cubicle4.closeEnoughPos.col ) then
			flo:StartProc(talk_to_cubicle4);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

function goto_exit(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("flo");
	wait_walkto();
	
	goto_scene(flo, "m3_landing13");
end

landing_door_spec = 
{
	name = "LANDING_DOOR";
	halo = "exit_door";
	goto_fn = goto_exit;
	cursor = "cursor_arrow_n";
}

debugPrint_spec =
{
	name = "debugPrint";
	
	command = function(actor)
		actor:SetDepthValue( 3000 );
		
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 30,
			x = -15,
			w = 90,
			h = 25,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
}

local mug_reach_pos = 
{ 
	{ row = 1, col = 2 },	-- mug 1
	{ row = 2 , col = 4 },	-- mug 2
	{ row = 3 , col = 1 },	-- mug 3
	{ row = 3 , col = 3 },	-- mug 4
	{ row = 3 , col = 5 },	-- mug 5
	{ row = 5 , col = 1 },	-- mug 6
	{ row = 5 , col = 2 },	-- mug 7
	{ row = 5 , col = 6 },	-- mug 8
	{ row = 6 , col = 1 },	-- mug 9
	{ row = 6 , col = 7 }	-- mug 10
}				
	
function get_closer_to_mug(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_maze2_get_closer");
	flo:SetMode(MODE.FOLLOWCLICKS);
end
	
function dont_need_mugs(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_dont_need_mugs");
	flo:SetMode(MODE.FOLLOWCLICKS);
end	
	
function get_mug_spec(index)
	return
	{
		name = "MUG_" .. tostring(index);
		halo = "mug";
		gfx = { image = "maze2_mug" };
		
		command = function(actor)		
			if ( game:Get("got_mug_" .. index) ~= 1 ) then			
				actor:JumpToNamedPoint( "mug_" .. tostring(index) );
			else
				actor:SetAlpha( 0 );
			end
			actor:SetDepthValue( 2000 );		
		end;
		
		on_click = function(flo, mug)
			if ( game:Get( "got_permit" ) ~= 1 ) then		
				return;
			end
			if ( game:Get( "talked_to_barb_1" ) ~= 1 ) then
				flo:StartProc(dont_need_mugs)
				return;
			end
			if ( maze_position.row == mug_reach_pos[index].row and maze_position.col == mug_reach_pos[index].col ) then
				game:Set("got_mug_" .. index, 1);
				local mugs_found = game:Get("mugs_found");
				mugs_found = mugs_found + 1;
				game:Set("mugs_found", mugs_found);
				sfx:PlaySFX("audio/sfx/big_mug");
				
				--local position = mug:GetZoneWalkToPoint();
				local position = mug:GetScreenPosition();
				position.x = position.x + mug:GetImageSize().x / 2;
				position.y = position.y - mug:GetImageSize().y / 2;
				local key = inv_desc_mugcollection.key;
				
				game:SetString("inventory_fly_back_item", key);
				game:Set("inventory_fly_back_loc_X", position.x);
				game:Set("inventory_fly_back_loc_Y", position.y);
				
				mug:Expire();
				scene.FLO:StartProc(wait_for_mug_fly)
				return RESPONSE.IGNORE;
			else
				flo:StartProc(get_closer_to_mug)
			end
		end;
	};
end

function wait_for_mug_fly(flo)
	flo:SetMode(MODE.CUTSCENE);
	local mugs_found = game:Get("mugs_found");
	local key = game:GetString("inventory_fly_back_item");
	
	if mugs_found == 1 then
		addInventory(inv_desc_mugcollection);
	else		
		-- scroll so the item's SLOT is visible
		BAG_INV:PositionInventoryForVisibility(key);
		
		-- go straight there (don't wait)
		BAG_INV:JumpInventoryToTarget(key);
		
		-- do the work
		scene:Spawn(inventory_flyback_spec);
		coroutine.yield(RESUME.ON_SIGNAL);
		
		-- re-enable the item
		BAG_INV:ShowInventory(key, true);
		
		--delay(30); -- make it snappy!
		scene.INVENTORY_FLYBACK:Expire();
		delay(2);
	end
	
	if mugs_found == game:Get( "max_mugs" ) then
		BAG_INV:RemoveInventory("mugcollection");
		BAG_INV:AddInventory(inv_desc_mugs);
		
		BAG_INV:SetInventoryOvertextFlags("mugs", kHAlignCenter + kVAlignTop);
		local mugText = tostring(mugs_found) .. " / "  .. tostring(game:Get( "max_mugs" ));
		BAG_INV:SetInventoryOvertext("mugs", mugText);
		
		run_super_conversation(flo, "conv_got_last_mug");
		spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_display.ogg");
		coroutine.yield(RESUME.ON_SIGNAL);
	else
		if mugs_found == 1 then
			BAG_INV:SetInventoryOvertextFlags("mugcollection", kHAlignCenter + kVAlignTop);
		end
		
		local mugText = tostring(mugs_found) .. " / "  .. tostring(game:Get( "max_mugs" ));
		BAG_INV:SetInventoryOvertext("mugcollection", mugText);
	end
	
	-- clean up
	game:SetString("inventory_fly_back_item", "");
	game:Set("inventory_fly_back_loc_X", "");
	game:Set("inventory_fly_back_loc_Y", "");
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function spawn_mugs()
	for i = 1, game:Get( "max_mugs" ) do
		scene:Spawn( get_mug_spec( i ) );
	end
end

maze_fax_spec = 
{
	name = "MAZE_FAX";
	halo = "maze_fax";
	
	command = function(actor)
		actor:SetDepthValue(5);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				sfx:PlaySFX("audio/sfx/big_fax");
				delay(20);
				run_super_conversation(flo, "quip_maze_fax");
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		);
	end;
}

poster_text_spec = 
{
	name = "POSTER_TEXT";
	
	command = function(actor)
		actor:SetDepthValue(101);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 1, g = 2, b = 2 },
			outline_size = 0,
			lineheight = 50,
			linepadding = 0,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_poster");
		actor:StopWalking();
		actor:SetPolygon({x=1295,y=148}, {x=1441,y=148}, {x=1295,y=164}, {x=1441,y=164});
		actor:TextToImage(10, 10);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
		scene:SetFadeColor { a = 1, r = 0, g = 0, b = 0 };
		
		spawn_load_bar("MAZE_LOAD", "text_maze_load", 10);
		
		coroutine.yield(RESUME.ON_DELAY);
		
		if IsCheatMode() then
			-- testing data
		end
		
		scene:LoadAtlas("quest/m3_maze_shared/pieces1"); -- load pieces
		scene:LoadAtlas("quest/m3_maze_shared/arrows"); -- load arrows
		scene:LoadAtlas("pieces1");
		scene:LoadAtlas("pieces2");
		scene:LoadAtlas("pieces3");
		
		update_load_bar("MAZE_LOAD", 1);
		
		spawn_mugs();
		
		spawn_simple_hotspot("maze_plant", 5);
		spawn_simple_hotspot("maze_cooler", 5);
		spawn_simple_hotspot("maze_file", 5);
		spawn_simple_hotspot("maze_soda", 5);
		spawn_simple_hotspot("maze_donuts", 5, 3);
		spawn_simple_hotspot("maze_recycle", 5);
		spawn_simple_hotspot("maze_poster3", 5);
		spawn_simple_hotspot("maze_poster4", 5);
		spawn_simple_hotspot("maze_calendar", 5);
		spawn_simple_hotspot("maze2_plantworker", 5);
		
		update_load_bar("MAZE_LOAD", 2);
		
		spawn_nav_arrow(landing_door_spec);
		
		spawn_bg_actor( "maze2_exit2", 100 );
		spawn_bg_actor( "maze2_furniture01", 100 );
		spawn_bg_actor( "maze2_furniture02", 100 );
		spawn_bg_actor( "maze2_furniture03", 100 );
		spawn_bg_actor( "maze2_furniture04", 260 );
		spawn_bg_actor( "maze2_furniture05", 100 );
		spawn_bg_actor( "maze2_furniture06", 260 );
		spawn_bg_actor( "maze2_furniture07", 500 );
		spawn_bg_actor( "maze2_furniture08", 500 );
		spawn_bg_actor( "maze2_furniture09", 500 );
		spawn_bg_actor( "maze2_furniture10", 695 );
		spawn_bg_actor( "maze2_furniture11", 695 );
		spawn_bg_actor( "maze2_furniture12", 765 );
		spawn_bg_actor( "maze2_furniture13", 840 );
		spawn_bg_actor( "maze2_furniture14", 1060 );
		spawn_bg_actor( "maze2_furniture15", 1035 );
		spawn_bg_actor( "maze2_furniture16", 1310 );
		spawn_bg_actor( "maze2_furniture17", 1310 );
		spawn_bg_actor( "maze2_furniture18", 1585 );
		spawn_bg_actor( "maze2_furniture19", 1775 );
		spawn_bg_actor( "maze2_furniture20", 1605 );
		spawn_bg_actor( "maze2_furniture21", 1585 );
		
		update_load_bar("MAZE_LOAD", 3);
		
		spawn_bg_actor( "maze2_row1a", 404 );
		spawn_bg_actor( "maze2_row1b", 255 );
		spawn_bg_actor( "maze2_row1c", 403 );
		spawn_bg_actor( "maze2_row1d", 402 );
		spawn_bg_actor( "maze2_row1e", 401 );
		spawn_bg_actor( "maze2_row1f", 255 );
		spawn_bg_actor( "maze2_row1g", 400 );
		spawn_bg_actor( "maze2_row1h", 256 );
		spawn_bg_actor( "maze2_row1i", 255 );
		spawn_bg_actor( "chair_mask_2", 410 );
		
		update_load_bar("MAZE_LOAD", 4);
		
		--spawn_bg_actor( "character_norbert", 490 );
		spawn_bg_actor( "maze2_row2a", 674 );
		spawn_bg_actor( "maze2_row2b", 530 );
		spawn_bg_actor( "maze2_row2c", 673 );
		spawn_bg_actor( "maze2_row2d", 672 );
		spawn_bg_actor( "maze2_row2e", 671 );
		spawn_bg_actor( "maze2_row2f", 531 );
		spawn_bg_actor( "maze2_row2g", 530 );
		spawn_bg_actor( "maze2_row2h", 670 );
		spawn_bg_actor( "maze2_row2i", 531 );
		spawn_bg_actor( "maze2_row2j", 530 );
		
		update_load_bar("MAZE_LOAD", 5);
		
		--spawn_bg_actor( "character_rosie", 812 );
		spawn_bg_actor( "maze2_row3a", 945 );
		spawn_bg_actor( "maze2_row3b", 810 );
		spawn_bg_actor( "maze2_row3c", 944 );
		spawn_bg_actor( "maze2_row3d", 943 );
		spawn_bg_actor( "maze2_row3e", 942 );
		spawn_bg_actor( "maze2_row3f", 810 );
		spawn_bg_actor( "maze2_row3g", 941 );
		spawn_bg_actor( "maze2_row3h", 810 );
		spawn_bg_actor( "maze2_row3i", 940 );
		spawn_bg_actor( "maze2_row3j", 811 );
		spawn_bg_actor( "maze2_row3k", 810 );
		
		update_load_bar("MAZE_LOAD", 6);
		
		--spawn_bg_actor( "character_loretta", 1025 );
		spawn_bg_actor( "maze2_row4a", 1223 );
		spawn_bg_actor( "maze2_row4b", 1080 );
		spawn_bg_actor( "maze2_row4c", 1222 );
		spawn_bg_actor( "maze2_row4d", 1221 );
		spawn_bg_actor( "maze2_row4e", 1080 );
		spawn_bg_actor( "maze2_row4f", 1220 );
		spawn_bg_actor( "maze2_row4g", 1081 );
		spawn_bg_actor( "maze2_row4h", 1080 );
		--spawn_bg_actor( "character_joe", 1275 );
		--spawn_bg_actor( "character_chloe", 1280 );
		
		update_load_bar("MAZE_LOAD", 7);
		
		spawn_bg_actor( "maze2_row5a", 1506 );
		spawn_bg_actor( "maze2_row5b", 1360 );
		spawn_bg_actor( "maze2_row5c", 1505 );
		spawn_bg_actor( "maze2_row5d", 1504 );
		spawn_bg_actor( "maze2_row5e", 1503 );
		spawn_bg_actor( "maze2_row5f", 1360 );
		spawn_bg_actor( "maze2_row5g", 1502 );
		spawn_bg_actor( "maze2_row5h", 1501 );
		spawn_bg_actor( "maze2_row5i", 1360 );
		spawn_bg_actor( "maze2_row5j", 1500 );
		spawn_bg_actor( "maze2_row5k", 1359 );
		spawn_bg_actor( "maze2_row5l", 1360 );
		
		update_load_bar("MAZE_LOAD", 8);
		
		spawn_bg_actor( "maze2_row6a", 1804 );
		spawn_bg_actor( "maze2_row6b", 1630 );
		spawn_bg_actor( "maze2_row6c", 1803 );
		spawn_bg_actor( "maze2_row6d", 1802 );
		spawn_bg_actor( "maze2_row6e", 1630 );
		spawn_bg_actor( "maze2_row6f", 1801 );
		spawn_bg_actor( "maze2_row6g", 1800 );
		spawn_bg_actor( "maze2_row6h", 1630 );
		
		update_load_bar("MAZE_LOAD", 9);
		
		scene:Spawn(cubicle2_spec);
		scene:Spawn(cubicle3_spec);
		scene:Spawn(cubicle4_spec);
		scene:Spawn(debugPrint_spec);
		scene:Spawn(maze_fax_spec);
		scene:Spawn(poster_text_spec);
		
		scene:Spawn(flo_spec);
		
		update_load_bar("MAZE_LOAD", 10);
		
		kill_load_bar("MAZE_LOAD");
		
		fade_scene_up();
	end;
};

scene_spec =
{
	atlas = 
	{
		"quest/m3_maze_shared/arrows", -- load arrows
		"quest/m3_maze_shared/pieces1", -- load pieces
		"pieces1",
		"pieces2",
		"pieces3",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		--[[
		{ "maze2_exit2", 100 };
		{ "maze2_furniture01", 100 };
		{ "maze2_furniture02", 100 };
		{ "maze2_furniture03", 100 };
		{ "maze2_furniture04", 260 };
		{ "maze2_furniture05", 100 };
		{ "maze2_furniture06", 260 };
		{ "maze2_furniture07", 500 };
		{ "maze2_furniture08", 500 };
		{ "maze2_furniture09", 500 };
		{ "maze2_furniture10", 695 };
		{ "maze2_furniture11", 695 };
		{ "maze2_furniture12", 765 };
		{ "maze2_furniture13", 840 };
		{ "maze2_furniture14", 1060 };
		{ "maze2_furniture15", 1035 };
		{ "maze2_furniture16", 1310 };
		{ "maze2_furniture17", 1310 };
		{ "maze2_furniture18", 1585 };
		{ "maze2_furniture19", 1775 };
		{ "maze2_furniture20", 1605 };
		{ "maze2_furniture21", 1585 };
		
		{ "maze2_row1a", 404 },
		{ "maze2_row1b", 255 },
		{ "maze2_row1c", 403 },
		{ "maze2_row1d", 402 },
		{ "maze2_row1e", 401 },
		{ "maze2_row1f", 255 },
		{ "maze2_row1g", 400 },
		{ "maze2_row1h", 256 },
		{ "maze2_row1i", 255 },
		{ "chair_mask_2", 410 },
		--{ "character_norbert", 490 },
		{ "maze2_row2a", 674 },
		{ "maze2_row2b", 530 },
		{ "maze2_row2c", 673 },
		{ "maze2_row2d", 672 },
		{ "maze2_row2e", 671 },
		{ "maze2_row2f", 531 },
		{ "maze2_row2g", 530 },
		{ "maze2_row2h", 670 },
		{ "maze2_row2i", 531 },
		{ "maze2_row2j", 530 },
		--{ "character_rosie", 812 },
		{ "maze2_row3a", 945 },
		{ "maze2_row3b", 810 },
		{ "maze2_row3c", 944 },
		{ "maze2_row3d", 943 },
		{ "maze2_row3e", 942 },
		{ "maze2_row3f", 810 },
		{ "maze2_row3g", 941 },
		{ "maze2_row3h", 810 },
		{ "maze2_row3i", 940 },
		{ "maze2_row3j", 811 },
		{ "maze2_row3k", 810 },
		--{ "character_loretta", 1025 },
		{ "maze2_row4a", 1223 },
		{ "maze2_row4b", 1080 },
		{ "maze2_row4c", 1222 },
		{ "maze2_row4d", 1221 },
		{ "maze2_row4e", 1080 },
		{ "maze2_row4f", 1220 },
		{ "maze2_row4g", 1081 },
		{ "maze2_row4h", 1080 },
		--{ "character_joe", 1275 },
		--{ "character_chloe", 1280 },
		{ "maze2_row5a", 1506 },
		{ "maze2_row5b", 1360 },
		{ "maze2_row5c", 1505 },
		{ "maze2_row5d", 1504 },
		{ "maze2_row5e", 1503 },
		{ "maze2_row5f", 1360 },
		{ "maze2_row5g", 1502 },
		{ "maze2_row5h", 1501 },
		{ "maze2_row5i", 1360 },
		{ "maze2_row5j", 1500 },
		{ "maze2_row5k", 1359 },
		{ "maze2_row5l", 1360 },
		
		{ "maze2_row6a", 1804 },
		{ "maze2_row6b", 1630 },
		{ "maze2_row6c", 1803 },
		{ "maze2_row6d", 1802 },
		{ "maze2_row6e", 1630 },
		{ "maze2_row6f", 1801 },
		{ "maze2_row6g", 1800 },
		{ "maze2_row6h", 1630 },
		--]]
		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
	};
};


